package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 苏宁确认收货
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningConfirmOrderParam implements Serializable {

    /**
     * 第三方订单号
     */
    @NotBlank(message = "第三方订单号不能为空")
    private String orderId;

    /**
     * sku
     */
    @NotEmpty(message = "sku列表不能为空")
    private List<String> skuList;

}
