package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 16:09
 */
@Getter
@AllArgsConstructor
public enum AuditOpEnum implements IEnum<Integer> {

    /**
     * ALL_PASS(1, "全部通过"),
     * ALL_REJECT(2, "全部拒绝");
     */
    ALL_PASS(1, "全部通过"),
    ALL_REJECT(2, "全部拒绝");

    private final Integer code;
    private final String desc;

    @Override
    public Integer getDbCode() {
        return code;
    }
}
