package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Pattern;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UpdatePasswordParams {

    @Pattern(regexp = RegexpConst.PASSWORD, message = "新密码格式不正确")
    @DataSecretFiledAnnotation
    private String newPassword;
    @Pattern(regexp = RegexpConst.PASSWORD, message = "旧密码格式不正确")
    @DataSecretFiledAnnotation
    private String oldPassword;
    @Pattern(regexp = RegexpConst.PASSWORD, message = "确认密码格式不正确")
    @DataSecretFiledAnnotation
    private String confirmPassword;
}
