package cn.com.duiba.cloud.manage.service.api.model.enums.tag;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 标签来源类型
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/1
 */
@Getter
public enum TagSourceTypeEnum implements IEnum<Integer> {

    /**
     * 仅用于 zy_tag、zy_tag_value 表
     */
    LOCAL(1,"本地"),
    WECHAT(2,"微信"),
    ZHOULI(3,"州力"),
    ALI(4, "阿里");

    private final Integer type;
    private final String desc;
    TagSourceTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    @Override
    public Integer getDbCode() {
        return type;
    }
}
