package cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 个人信息修改
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/7
 */
@Data
public class RemoteConsumerInfoConfigEditInfoContentParam implements Serializable {

    private static final long serialVersionUID = 4846108684963066078L;

    /**
     * id
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 信息标题
     */
    @NotBlank(message = "信息标题不能为空")
    private String infoTopic;

    /**
     * 信息题目
     */
    @NotBlank(message = "信息题目不能为空")
    private String infoContent;

    /**
     * 操作人
     */
    @NotNull(message = "未知操作人")
    private Long operator;

}
