package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.KvDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.scan.CreditsConsumeStatisticalDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.scan.FocusProductScanStatisticalDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.scan.GrantPrizeStatisticalDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 扫码看板remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-10-17 14:00
 * @since 3.0.6
 **/
@AdvancedFeignClient
public interface RemoteDatavScanService {
    /**
     * 手动补扫码有礼数据
     *
     * @return ok
     */
    String handler();

    /**
     * 获取扫码有礼活动信息
     *
     * @return kvDTO
     */
    List<KvDTO> listActivity();

    /**
     * 根据活动id查询重点规格信息
     *
     * @param activityId 活动id
     * @return 重点规格信息
     */
    List<FocusProductScanStatisticalDTO> listFocusProductScanStatistical(
            @NotBlank(message = "活动id不能为空") String activityId);

    /**
     * 通过活动id获取积分消耗强行
     *
     * @param activityId 活动id
     * @return 获取积分消耗强行
     */
    CreditsConsumeStatisticalDTO getCreditsConsumeStatistical(@NotBlank(message = "活动id不能为空") String activityId);

    /**
     * 通过活动id获取出奖详情
     *
     * @param activityId 活动id
     * @return 出奖详情
     */
    List<GrantPrizeStatisticalDTO> getGrantPrizeStatistical(@NotBlank(message = "活动id不能为空") String activityId);
}
