package cn.com.duiba.cloud.manage.service.api.model.dto.exportrecord.statistics;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author xiaotian
 * @ClassName ExportStatisticsUnitData.java
 * @createTime 2022年02月10日 11:33:00
 * @Description
 */
@Getter
@Setter
public class ExportStatisticsUnitData implements Serializable {

    private static final long serialVersionUID = -1683595476014691153L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 日期
     */
    @ExcelProperty("日期")
    private String date;
    /**
     * 页面ID
     */
    @ExcelProperty("页面ID")
    private Long pageId;

    /**
     * 页面名称
     */
    @ExcelProperty("页面名称")
    private String pageName;

    /**
     * 组件名称
     */
    @ExcelProperty("组件名称")
    private String unitName;

    /**
     * 组件在页面内位置
     */
    @ExcelProperty("组件在页面内位置")
    private Integer unitLocation;

    /**
     * 组件内位置
     */
    @ExcelProperty("组件内位置")
    private Integer innerUnitLocation;

    /**
     * 曝光PV
     */
    @ExcelProperty("曝光PV")
    private Long exPv;
    /**
     * 组件曝光uv
     */
    @ExcelProperty("曝光UV")
    private Long exUv;

    /**
     * 组件点击pv
     */
    @ExcelProperty("点击PV")
    private Long clPv;
    /**
     * 组件点击uv
     */
    @ExcelProperty("点击UV")
    private Long clUv;
}
