package cn.com.duiba.cloud.manage.service.api.model.dto.ocr;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 陈列识别
 * @Date 2022/7/29 18:10
 * @Author LuHui
 */
@Data
public class DisplayOcrDto implements Serializable {
    private static final long serialVersionUID = 7946989521436771369L;


    /**
     * [int32]0表示成功
     */
    @JSONField(name = "err_code")
    private Integer errCode;
    /**
     * 错误描述
     */
    @JSONField(name = "err_desc")
    private String errDesc;

    /**
     * 错误名
     */
    @JSONField(name = "err_name")
    private String errName;

    /**
     * 结果
     */
    private ResultDto result;

    /**
     * 是否成功
     * @return
     */
    public boolean success(){
        return Integer.valueOf(0).equals(this.getErrCode());
    }

    @Data
    public static class ResultDto implements Serializable{

        private static final long serialVersionUID = -8515221646268792172L;

        /**
         * [array-object]卷烟列表
         */
        private List<CigaretDto> cigarettes;
        /**
         * [int32]0正常陈列，1非正常陈列。正常陈列对应一般陈列柜中的陈列，而非摆拍
         */
        private Integer stage;

        /**
         * 翻拍检测，只有check_fake_image为true的时候才有此字段
         */
        @JSONField(name = "fake_image")
        private FakeImageDto fakeImage;
    }

    @Data
    public static class CigaretDto implements Serializable{

        private static final long serialVersionUID = 5044453183575137257L;

        /**
         * string]规格名
         */
        private String category;
        /**
         * [int32]数量
         */
        private Integer count;
    }

    @Data
    public static class FakeImageDto implements Serializable{

        private static final long serialVersionUID = 5774008901423481383L;

        /**
         * 是否翻拍
         */
        private Boolean fake;
    }
}
