package cn.com.duiba.cloud.manage.service.api.model.dto.importdata;

import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * 供应商商品导入dto
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/19
 */
@Getter
@Setter
public class ImportSaveSupplierGoodsData extends BaseImportData{

    private static final long serialVersionUID = 7916701336717920157L;

    @ExcelProperty("商品编码（第三方skuId）")
    private String sku;

    @ExcelProperty("库存")
    private String stock;

    @ExcelProperty("成本价")
    private String price;

    @ExcelProperty("导入结果")
    private String result;

    /**
     * sku最大值
     */
    private static final Integer MAX_SKU_SIZE = 50;

    /**
     * 校验数据，并且塞进去错误原因
     *
     * @return 是否通过校验
     */
    public boolean dataCheck() {
        if (StringUtils.isBlank(this.getSku())) {
            this.setErrorMessage("商品编码未填写");
            return false;
        }
        if (StringUtils.isBlank(this.getStock())) {
            this.setErrorMessage("库存未填写");
            return false;
        }
        if (StringUtils.isBlank(this.getPrice())) {
            this.setErrorMessage("成本价未填写");
            return false;
        }
        if (this.getSku().length() > MAX_SKU_SIZE) {
            this.setErrorMessage("商品编码格式错误");
            return false;
        }
        if (!Pattern.matches(RegexpConst.STOCK_PATTERN, this.getStock())) {
            this.setErrorMessage("库存格式错误");
            return false;
        }
        if (!Pattern.matches(RegexpConst.PRICE_PATTERN, this.getPrice())) {
            this.setErrorMessage("成本价格式错误");
            return false;
        }
        return true;
    }

}
