package cn.com.duiba.cloud.manage.service.api.model.dto.supplier;

import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliLogisticsTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 订单发货信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/2/7
 */
@Getter
@Setter
public class DeliGetDeliveryInfoDTO implements Serializable {

    private static final long serialVersionUID = 4216489552619594146L;

    /**
     * 发货单号
     */
    private String deliveryId;

    /**
     * 采购平台单号
     */
    private String pxOrderId;

    /**
     * 发货状态 1-已发货
     */
    private Integer sendState;

    /**
     * 物流信息获取类型 1-第三方标准物流 2-供应 商提供物流信息查询
     * @see DeliLogisticsTypeEnum
     */
    private Integer logisticsType;

    /**
     * 物流公司名称（当 logisticsType=1 时，此项必填）
     */
    private String logisticsCom;

    /**
     * 物流公司编号（当 logisticsType=1 时，此项必填）
     */
    private String logisticsComNo;

    /**
     * 物流单号（当 logisticsType=1 时，此项必填）
     */
    private String logisticsNo;

    /**
     * 发货单明细
     */
    private List<DeliDeliveryDetailDTO> deliveryDetail;

}
