package cn.com.duiba.cloud.manage.service.api.model.enums;


import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description
 * @Date 2022/8/2 15:44
 * @Author LuHui
 */
public enum DisplayOcrTypeEnum {
    //包
    PACK(0, "pack"),
    //条
    CARTON(1, "carton"),
    ;

    private Integer code;
    private String type;

    DisplayOcrTypeEnum(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public Integer getCode() {
        return code;
    }

    public String getType() {
        return type;
    }

    public static DisplayOcrTypeEnum getDisplayOrcTypeEnum(Integer code)  {
        // 默认条
       return Stream.of(DisplayOcrTypeEnum.values()).filter(x -> Objects.equals(x.getCode(), code)).findFirst().orElse(CARTON);
    }
}
