package cn.com.duiba.cloud.manage.service.api.model.enums.wechat;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;

/**
 * @author wangxukai
 * @description 微信素材类型
 * @date ：Created in 2022/1/11
 */
@Getter
public enum WechatMaterialEnum {
    NEWS(1,"图文","news","mpnews"),
    PIC(2,"图片","image","image"),
    VIDEO(3,"视频","video","mpvideo"),
    VOICE(4,"音频","voice","voice"),
    ;
    private Integer type;

    private String desc;
    private String wxType;
    private String previewType;
    WechatMaterialEnum(Integer type,String desc,String wxType,String previewType){
        this.type = type;
        this.desc = desc;
        this.wxType = wxType;
        this.previewType = previewType;
    }

    public static WechatMaterialEnum getByType(Integer type) throws BizException {
        for(WechatMaterialEnum materialEnum : WechatMaterialEnum.values()){
            if(materialEnum.getType().equals(type)){
                return materialEnum;
            }
        }
        throw new BizException("素材类型不存在");
    }

    public static WechatMaterialEnum getByWxType(String wxType) throws BizException {
        for(WechatMaterialEnum materialEnum : WechatMaterialEnum.values()){
            if(materialEnum.getWxType().equals(wxType)){
                return materialEnum;
            }
        }
        throw new BizException("素材类型不存在");
    }

}
