package cn.com.duiba.cloud.manage.service.api.model.param.importdata;

import cn.com.duiba.cloud.manage.service.api.model.enums.importdata.ImportStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;

import java.util.Date;
import java.util.List;

/**
 * @author linzhou
 * @ClassName RemoteImportRecordListRequest.java
 * @createTime 2021年11月29日 10:34:00
 * @Description
 */
public class RemoteImportRecordListRequest extends BaseParam {

    private static final long serialVersionUID = -7159981693987571551L;

    /**
     * 任务编号
     */
    private Long id;

    /**
     * 导入类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.importdata.ImportDataTypeEnum
     */
    private List<Byte> type;
    /**
     * 导入时间范围
     */
    private Date startTime;
    /**
     * 导入时间范围
     */
    private Date endTime;


    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    /**
     * 任务状态 {@link ImportStateEnum}
     */
    private Integer taskState;

    public Integer getTaskState() {
        return taskState;
    }

    public void setTaskState(Integer taskState) {
        this.taskState = taskState;
    }

    public List<Byte> getType() {
        return type;
    }

    public void setType(List<Byte> type) {
        this.type = type;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
