package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

/**
 * @author xuanhongjian
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class ProvinceConsumerDTO extends BusinessConsumerDTO implements Serializable {

    private static final long serialVersionUID = 606446136736126832L;
    /**
     * 省份下市区数据
     */
    List<CityConsumerDTO> cityConsumerDTOList;

    private String provinceName;
    private String code;

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
        if (progress != null) {
            this.progressStr = progress.toPlainString();
        }
    }

    public void setSecondProgress(BigDecimal secondProgress) {
        this.secondProgress = secondProgress;
        if (secondProgress != null) {
            this.secondProgressStr = secondProgress.toPlainString();
        }
    }

    /**
     * 汇总数据
     */
    public void summary() {
        if (CollectionUtils.isEmpty(cityConsumerDTOList)) {
            return;
        }
        followingCount = followingCount == null ? 0L : followingCount;
        registerCount = registerCount == null ? 0L : registerCount;
        increaseCount = increaseCount == null ? 0L : increaseCount;
        consumerCount = consumerCount == null ? 0L : consumerCount;
        //累加获取省份汇总数据
        for (CityConsumerDTO cityConsumerDTO : cityConsumerDTOList) {
            //关注量

            long cityFollowCount = cityConsumerDTO.getFollowingCount() == null ? 0L
                                       : cityConsumerDTO.getFollowingCount();
            followingCount = cityFollowCount + followingCount;

            //注册量
            long cityRegisterCount = cityConsumerDTO.getRegisterCount() == null ? 0L
                                         : cityConsumerDTO.getRegisterCount();
            registerCount = cityRegisterCount + registerCount;

            //新增量
            long cityIncr = cityConsumerDTO.getIncreaseCount() == null ? 0L
                                : cityConsumerDTO.getIncreaseCount();
            increaseCount = cityIncr + increaseCount;
            Long cityConsumerCount = cityConsumerDTO.getConsumerCount() == null ? 0L
                                         : cityConsumerDTO.getConsumerCount();
            consumerCount = consumerCount + cityConsumerCount;
        }
    }

    /**
     * 计算进度
     */
    public void calculateSchedule() {
        //进度（第一个） 关注量÷目标关注量
        this.setProgress(firstSchedule(followingCount, followingCountTarget));
        //进度第二个 新增量÷目标新增量（净增量）
        this.setSecondProgress(secondSchedule(increaseCount, followingIncreaseCountTarget));
        //省份数据进度
        if (CollectionUtils.isNotEmpty(cityConsumerDTOList)) {
            cityConsumerDTOList.forEach(cityConsumerDTO -> {
                cityConsumerDTO.setProgress(firstSchedule(cityConsumerDTO.getFollowingCount(),
                    cityConsumerDTO.getFollowingCountTarget()));
                cityConsumerDTO.setSecondProgress(secondSchedule(cityConsumerDTO.getIncreaseCount(),
                    cityConsumerDTO.getFollowingIncreaseCountTarget()));
            });
        }
    }

    private BigDecimal firstSchedule(Long followingCount, Long followingCountTarget) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
        // 进度（第一个） 关注量÷目标关注量
        if (followingCount == null || followingCount == 0L) {
            bigDecimal = new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP);
        } else {
            if (followingCountTarget == null || followingCountTarget == 0L) {
                bigDecimal = new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP);
            }else{
                bigDecimal = new BigDecimal(followingCount).multiply(new BigDecimal(100))
                                 .divide(new BigDecimal(followingCountTarget), 2,
                                     BigDecimal.ROUND_HALF_DOWN)
                                 .setScale(2, BigDecimal.ROUND_HALF_UP);
            }
        }
        return bigDecimal;
    }

    private BigDecimal secondSchedule(Long increaseCount, Long followingIncreaseCountTarget) {
        BigDecimal bigDecimal=new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
        if (increaseCount == null || increaseCount == 0) {
            bigDecimal = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
        } else {
            if (followingIncreaseCountTarget == null || followingIncreaseCountTarget == 0L) {
                bigDecimal = new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP);
            }else{
                bigDecimal = new BigDecimal(increaseCount).multiply(new BigDecimal(100))
                                 .divide(new BigDecimal(followingIncreaseCountTarget), 2,
                                     BigDecimal.ROUND_HALF_DOWN)
                                 .setScale(2, BigDecimal.ROUND_HALF_UP);
            }
        }
        return bigDecimal;
    }
}
