package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.cloud.manage.service.api.annotation.EnumValid;
import cn.com.duiba.cloud.manage.service.api.model.enums.terminal.ReceiveConditionEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/9 15:26
 **/
@Getter
@Setter
public class RemoteReceiveConditionQueryParam implements Serializable {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 类型
     * @see ReceiveConditionEnum
     */
    @EnumValid(target = ReceiveConditionEnum.class, message = "类型不合法")
    private Integer type;
}
