/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.BusinessDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.CityRetailerDTO;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ProvinceRetailerDTO
extends BusinessDTO {
    private static final long serialVersionUID = 2106660744346967509L;
    List<CityRetailerDTO> cityRetailerList;
    private String provinceName;
    private String code;

    @Override
    public void setTargetProgress(BigDecimal targetProgress) {
        this.targetProgress = targetProgress;
        if (targetProgress != null) {
            this.targetProgressStr = targetProgress.toPlainString();
        }
    }

    public void summary() {
        List<CityRetailerDTO> cityRetailerList = this.cityRetailerList;
        if (CollectionUtils.isEmpty(cityRetailerList)) {
            return;
        }
        cityRetailerList.forEach(cityRetailerDTO -> {
            this.userCount = this.add(cityRetailerDTO.getUserCount(), this.userCount);
            this.userCountNotFollowing = this.add(cityRetailerDTO.getUserCountNotFollowing(), this.userCountNotFollowing);
            this.userIncreaseCountNotFollowing = this.add(cityRetailerDTO.getUserIncreaseCountNotFollowing(), this.userIncreaseCountNotFollowing);
            this.inviteAccumulativeCount = this.add(cityRetailerDTO.getInviteAccumulativeCount(), this.inviteAccumulativeCount);
            this.inviteSingleMonthCount = this.add(cityRetailerDTO.getInviteSingleMonthCount(), this.inviteSingleMonthCount);
            this.phwdAccumulativeCount = this.add(cityRetailerDTO.getPhwdAccumulativeCount(), this.phwdAccumulativeCount);
            this.phwdSingleMonthCount = this.add(this.phwdSingleMonthCount, cityRetailerDTO.getPhwdSingleMonthCount());
            this.selfDisciplineAccumulativeCount = this.add(this.selfDisciplineAccumulativeCount, cityRetailerDTO.getSelfDisciplineAccumulativeCount());
            this.selfDisciplineSingleMonthCount = this.add(this.selfDisciplineSingleMonthCount, cityRetailerDTO.getSelfDisciplineSingleMonthCount());
            this.leagueAccumulativeCount = this.add(this.leagueAccumulativeCount, cityRetailerDTO.getLeagueAccumulativeCount());
            this.leagueSingleMonthCount = this.add(this.leagueSingleMonthCount, cityRetailerDTO.getLeagueSingleMonthCount());
            this.getCustomersAccumulativeCount = this.add(this.getCustomersAccumulativeCount, cityRetailerDTO.getGetCustomersAccumulativeCount());
            this.getCustomersSingleMonthCount = this.add(this.getCustomersSingleMonthCount, cityRetailerDTO.getGetCustomersSingleMonthCount());
            this.scanCodeAccumulativeCount = this.add(this.scanCodeAccumulativeCount, cityRetailerDTO.getScanCodeAccumulativeCount());
            this.scanCodeSingleMonthCount = this.add(this.scanCodeSingleMonthCount, cityRetailerDTO.getScanCodeSingleMonthCount());
            this.othersAccumulativeCount = this.add(this.othersAccumulativeCount, cityRetailerDTO.getOthersAccumulativeCount());
            this.othersSingleMonthCount = this.add(this.othersSingleMonthCount, cityRetailerDTO.getOthersSingleMonthCount());
        });
    }

    public void calculateSchedule() {
        this.setTargetProgress(this.calculateSchedule(new BigDecimal(this.userIncreaseCountNotFollowing == null ? 0L : this.userIncreaseCountNotFollowing), new BigDecimal(this.userIncreaseCountNotFollowingTarget == null ? 0L : this.userIncreaseCountNotFollowingTarget)));
        this.cityRetailerList.forEach(cityRetailerDTO -> {
            BigDecimal actualValue = new BigDecimal(cityRetailerDTO.getUserIncreaseCountNotFollowing() == null ? 0L : cityRetailerDTO.getUserIncreaseCountNotFollowing());
            BigDecimal targetValue = new BigDecimal(cityRetailerDTO.getUserIncreaseCountNotFollowingTarget() == null ? 0L : cityRetailerDTO.getUserIncreaseCountNotFollowingTarget());
            BigDecimal bigDecimal = this.calculateSchedule(actualValue, targetValue);
            cityRetailerDTO.setTargetProgress(bigDecimal);
        });
    }

    private BigDecimal calculateSchedule(BigDecimal actualValue, BigDecimal targetValue) {
        boolean targetFlag;
        BigDecimal progress = new BigDecimal(0L).setScale(2, 4);
        boolean actualFlag = actualValue == null || actualValue.compareTo(new BigDecimal(0)) == 0;
        boolean bl = targetFlag = targetValue == null || targetValue.compareTo(new BigDecimal(0)) == 0;
        if (targetFlag || actualFlag) {
            return progress;
        }
        progress = actualValue.multiply(new BigDecimal(100)).divide(targetValue, 2, 5).setScale(2, 5);
        return progress;
    }

    private Long add(Long first, Long second) {
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l + l1;
    }

    public static ProvinceRetailerDTOBuilder builder() {
        return new ProvinceRetailerDTOBuilder();
    }

    public List<CityRetailerDTO> getCityRetailerList() {
        return this.cityRetailerList;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCityRetailerList(List<CityRetailerDTO> cityRetailerList) {
        this.cityRetailerList = cityRetailerList;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvinceRetailerDTO)) {
            return false;
        }
        ProvinceRetailerDTO other = (ProvinceRetailerDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CityRetailerDTO> this$cityRetailerList = this.getCityRetailerList();
        List<CityRetailerDTO> other$cityRetailerList = other.getCityRetailerList();
        if (this$cityRetailerList == null ? other$cityRetailerList != null : !((Object)this$cityRetailerList).equals(other$cityRetailerList)) {
            return false;
        }
        String this$provinceName = this.getProvinceName();
        String other$provinceName = other.getProvinceName();
        if (this$provinceName == null ? other$provinceName != null : !this$provinceName.equals(other$provinceName)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProvinceRetailerDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CityRetailerDTO> $cityRetailerList = this.getCityRetailerList();
        result = result * 59 + ($cityRetailerList == null ? 43 : ((Object)$cityRetailerList).hashCode());
        String $provinceName = this.getProvinceName();
        result = result * 59 + ($provinceName == null ? 43 : $provinceName.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProvinceRetailerDTO(cityRetailerList=" + this.getCityRetailerList() + ", provinceName=" + this.getProvinceName() + ", code=" + this.getCode() + ")";
    }

    public ProvinceRetailerDTO() {
    }

    public ProvinceRetailerDTO(List<CityRetailerDTO> cityRetailerList, String provinceName, String code) {
        this.cityRetailerList = cityRetailerList;
        this.provinceName = provinceName;
        this.code = code;
    }

    public static class ProvinceRetailerDTOBuilder {
        private List<CityRetailerDTO> cityRetailerList;
        private String provinceName;
        private String code;

        ProvinceRetailerDTOBuilder() {
        }

        public ProvinceRetailerDTOBuilder cityRetailerList(List<CityRetailerDTO> cityRetailerList) {
            this.cityRetailerList = cityRetailerList;
            return this;
        }

        public ProvinceRetailerDTOBuilder provinceName(String provinceName) {
            this.provinceName = provinceName;
            return this;
        }

        public ProvinceRetailerDTOBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ProvinceRetailerDTO build() {
            return new ProvinceRetailerDTO(this.cityRetailerList, this.provinceName, this.code);
        }

        public String toString() {
            return "ProvinceRetailerDTO.ProvinceRetailerDTOBuilder(cityRetailerList=" + this.cityRetailerList + ", provinceName=" + this.provinceName + ", code=" + this.code + ")";
        }
    }
}

