package cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量处理客户信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/12
 */
@Data
public class RemoteConsumerInfoBatchHandleParam implements Serializable {

    private static final long serialVersionUID = -3922802692733054300L;
    @NotNull(message = "客户id不能为空")
    private Long consumerId;

    @NotEmpty(message = "客户信息列表不能为空")
    @Valid
    private List<RemoteConsumerInfoParam> infoList;

}
