package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.SelfQrcodeBindDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteBindQrcodeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteDeleteBindParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteSelfQrcodeQueryParam;

import java.util.List;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:37:01
*/
@AdvancedFeignClient
public interface RemoteSelfQrcodeBindService {

    /**
     * 根据活动id和零售户id查询绑定关系
     * @param param 查询参数
     * @return List<SelfQrcodeBindDTO>
     */
    List<SelfQrcodeBindDTO> queryByActivityRetailerIdList(RemoteSelfQrcodeQueryParam param);

    /**
     * 绑定二维码, save
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean bindQrcode(RemoteBindQrcodeParam param);

    /**
     * 判断二维码是否已被绑定过
     * @param qrcodeId 二维码id
     * @return true 表示已被绑定
     */
    Boolean isBind(Long qrcodeId);

    /**
     * 根据二维码id查询信息
     * @param qrcodeId 二维码id
     * @return SelfQrcodeBindDTO
     */
    SelfQrcodeBindDTO queryByQrcodeId(Long qrcodeId);

    /**
     * 删除零售户和二维码绑定关系
     * @param param 参数
     */
    void deleteBind(RemoteDeleteBindParam param);
}
