package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description
 * @Date 2022/9/14 15:21
 * @Author LuHui
 */
@Data
public class RemoteYearPlanStatisticsDto implements Serializable {
    private static final long serialVersionUID = 4854805083932909354L;
    /**
     * id
     */
    private Long id;
    /**
     * 部门名称
     */
    private String department;
    /**
     * 零售户入网数
     */
    private BigDecimal saleAccessNum;
    /**
     * 消费者获客
     */
    private BigDecimal consumerAcquireNum;
    /**
     * 零售户活动交互
     */
    private BigDecimal saleJoinNum;
    /**
     * 消费者活动交互
     */
    private BigDecimal consumerJoinNum;
    /**
     * 推文宣传交互
     */
    private BigDecimal tweetJoinNum;
    /**
     * 策划推广费用
     */
    private BigDecimal planExtendCost;
    /**
     * 市场营销烟合计(万元)
     */
    private BigDecimal marketCigarettesCost;
    /**
     * 市场营销烟合计(条)
     */
    private BigDecimal marketCigarettesTotal;
    /**
     * 营销物资合计
     */
    private BigDecimal marketGoodNum;
    /**
     * 快递合计(单数)
     */
    private BigDecimal expressTotal;
    /**
     * 快递合计(万元)
     */
    private BigDecimal expressCost;
    /**
     * 零售户交互人均单价
     */
    private BigDecimal saleJoinAvg;
    /**
     * 消费者交互人均单价
     */
    private BigDecimal consumerJoinAvg;
    /**
     * 推文交互人均单价
     */
    private BigDecimal tweetJoinAvg;
}
