package cn.com.duiba.cloud.manage.service.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.page.DesignPageDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.page.DesignPageMsgDto;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPageCreateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPagePublishParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPageShareParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPageUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignPageUpdateVisibleRangeParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/2/8
 */
@AdvancedFeignClient
public interface RemoteDesignPageService {
    /**
     * 创建装修页面
     * @param param
     * @return id
     */
    Long create(RemoteDesignPageCreateParam param);

    /**
     * 更新
     * @param param
     * @return
     */
    Boolean update(RemoteDesignPageUpdateParam param);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 查看详情
     * @param id
     * @return
     */
    DesignPageDto detail(Long id);

    /**
     * 查看详情(最新发布)
     * @param id
     * @return
     */
    String detailLastPublish(Long id);


     /** 详情列表
     * @param ids
     * @return
             */
    List<DesignPageDto> details(List<Long> ids);

    /**
     * 分页查询装修页面
     * @param param
     * @return
     */
    PageResponse<DesignPageMsgDto> queryList(RemoteDesignPageQueryParam param);
    /**
     * 发布
     * @param param
     * @return
     */
    Boolean publish(RemoteDesignPagePublishParam param);

    /**
     * 编辑分享配置
     * @param param
     * @return
     */
    Boolean editShareConf(RemoteDesignPageShareParam param);

    /**
     * 取消定时发布
     * @param id
     * @return 发布后状态
     */
    Integer cancelPublishTask(Long id);

    /**
     * 修改可见范围
     * @param param
     * @return
     */
    Boolean updateVisibleRange(RemoteDesignPageUpdateVisibleRangeParam param);
}
