package cn.com.duiba.cloud.manage.service.api.remoteservice.user;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.user.AccountValidateDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.user.UserDto;
import cn.com.duiba.cloud.manage.service.api.model.param.user.GetUserByIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.ListUserByUserIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.ListUserParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.RegisterUserParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.RemoteResetPasswordParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.UpdatePasswordParam;
import cn.com.duiba.cloud.manage.service.api.model.param.user.UpdatePhoneParam;

import java.util.List;


/**
 * @author xuanhongjian 用户服务
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 根据员工编号查询用户信息
     *
     * @param userId 员工编号
     * @return 用户信息
     * @throws BizException e
     */
    UserDto queryUserByUserId(String userId) throws BizException;

    /**
     * 查询手机对应用户
     * @param phoneParam 手机号
     * @return 用户信息
     */
    List<UserDto> queryUserListByUserId(ListUserByUserIdParam phoneParam);

    /**
     * 验证登录信息
     * @param userId 员工编号
     * @param password 密码
     * @return 验证结果
     * @throws BizException e
     */
    AccountValidateDto validateAccount(String userId, String password) throws BizException;

    /**
     * 用户注册
     * @param param 用户信息
     * @return 注册结果
     */
    AccountValidateDto registerUser(RegisterUserParam param);

    /**
     * 批量注册账号
     * @param list 用户信息 list
     */
    void batchRegisterUser(List<RegisterUserParam> list);

    /**
     * 根据ID 查询用户
     * @param listUserParam ids
     * @return 用户信息
     */
    List<UserDto> listUserByIds(ListUserParam listUserParam);

    /**
     * 根据ID获取用户
     * @param param ID
     * @return 用户
     */
    UserDto getUserById(GetUserByIdParam param);

    /**
     * 修改手机号
     * @param updatePhoneParam 修改手机号参数
     * @return 修改结果
     */
    AccountValidateDto updatePhone(UpdatePhoneParam updatePhoneParam);

    /**
     * 修改密码
     * @param passwordParam 修改密码参数
     * @return 修改结果
     */
    AccountValidateDto updatePassword(UpdatePasswordParam passwordParam);

    /**
     * 重置密码
     * @param resetPasswordParam 参数
     * @throws BizException e
     */
    Long resetPassword(RemoteResetPasswordParam resetPasswordParam) throws BizException;
}
