package cn.com.duiba.cloud.manage.service.api.model.enums.system;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 部门类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-06 11:06
 * @since 0.0.3
 **/
@Getter
@AllArgsConstructor
public enum DeptTypeEnum implements IEnum<Integer> {
    /**
     * 后台新建部门
     */
    MANAGEMENT_DEPT(1, "后台新建部门"),

    /**
     * 钉钉同步部门
     */
    DING_TALK_DEPT(2, "钉钉同步部门"),
    ;

    /**
     * 部门类型值
     */
    private Integer dbCode;

    /**
     * 部门类型文本
     */
    private String text;
}
