package cn.com.duiba.cloud.manage.service.api.remoteservice.activity.vote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.vote.*;
import cn.com.duiba.cloud.manage.service.api.model.param.vote.*;
import cn.com.duiba.wolf.entity.PageResponse;


/**
 * @author zht
 * @Date 2022/8/4
 */
@AdvancedFeignClient
public interface RemoteActivityVoteService {


    /**
     * 活动中心数据(参与 访问)
     */
    ActivityVoteDataDto getVoteData(RemoteActivityVoteDataParam remoteActivityVoteDataParam) throws BizException;


    /**
     * 获取审核分页数据
     */

    PageResponse<ActivityVoteDto> getVotePageList(RemoteActivityVotePageParam remoteActivityVotePageParam);

    /**
     * 获取审核详情
     *
     * @param activityId
     * @param id
     * @return
     * @throws BizException
     */
    ActivityVoteDetailDto getVoteDetail(Long activityId, Long id) throws BizException;


    /**
     * 处理审核
     *
     * @param remoteActivityVoteUpdateParam
     * @throws BizException
     */
    void dealVoteResult(RemoteActivityVoteUpdateParam remoteActivityVoteUpdateParam) throws BizException;


    /**
     * 分页获取最近积分明细
     */
    PageResponse<ActivityVotePointDto> getUserVotePointRecord(RemoteUserCheckInfoPageParam remoteUserCheckInfoPageParam);

    /**
     * 获取用户明细
     */
    PageResponse<ActivityDisplayUserPointRecordDto> getUserVoteDetailList(RemoteActivityVotePointParam remoteActivityVotePointParam);
}
