package cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 两面两率DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-10-08 16:03
 * @since 3.0.2
 **/
@Data
@Accessors(chain = true)
public class RateOfSurfaceDTO implements Serializable {
    private static final long serialVersionUID = -7083448327364806911L;

    /**
     * 面
     */
    private SurfaceDTO surface;

    /**
     * 率
     */
    private RateDTO rate;

    /**
     * 面
     */
    @Data
    @Accessors(chain = true)
    public static class SurfaceDTO implements Serializable {
        private static final long serialVersionUID = -1044988672203520693L;

        /**
         * 进货面
         */
        private List<XyDTO> stockFace;

        /**
         * 订足面
         */
        private List<XyDTO> bookFullFace;
    }

    /**
     * 率
     */
    @Data
    @Accessors(chain = true)
    public static class RateDTO implements Serializable {
        private static final long serialVersionUID = -5812805413793482130L;

        /**
         * 订足率
         */
        private List<XyDTO> bookFullRate;

        /**
         * 订足满足率
         */
        private List<XyDTO> orderMeetRate;
    }
}
