package cn.com.duiba.cloud.manage.service.api.model.dto.replay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 复盘表
 * @TableName tb_replay
 */
@Data
public class ReplayDTO implements Serializable {

    private static final long serialVersionUID = -3292463090141421967L;
    /**
     * 复盘id
     */
    private Long id;

    /**
     * 关联复盘模板code
     */
    private String replayTemplateCode;

    /**
     * 复盘名称
     */
    private String replayName;

    /**
     * 复盘数据
     */
    private String replayData;

    /**
     * 关联活动信息
     */
    private List<ReplayBindActivityDTO> replayBindActivityDTOList;

    /**
     * 删除标记 0未删除 1已删除
     */
    private Boolean deleted;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private String creatorName;
}