package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import cn.hutool.core.bean.BeanException;
import com.google.common.collect.ImmutableList;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description
 * @Date 2022/9/9 17:20
 * @Author LuHui
 */
public enum PlanStatusEnum {
    WAIT_CONFIRM(0, "待确认"),
    ALREADY_CONFIRM(1, "已确认"),
    PREPARING(2, "筹备中"),
    PREPARE_COMPLETE(3, "筹备完成"),
    BEGINNING(4, "进行中"),
    END(5, "活动结束"),
    CLOSE(6, "已关闭"),
    ACTIVITY_END(7, "计划结束"),
    ;


    private Integer code;

    private String desc;

    PlanStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PlanStatusEnum getPlanStatusByCode(Integer code) {
        return Stream.of(PlanStatusEnum.values()).filter(x -> Objects.equals(code, x.getCode())).findFirst().orElseThrow(
                ()->new BeanException("参数类型有误")
        );
    }

    /**
     * 不可选状态
     * @return
     */
    public static List<Integer> getList() {
        return ImmutableList.of(WAIT_CONFIRM.code, ALREADY_CONFIRM.code, CLOSE.code);
    }
}
