package cn.com.duiba.user.server.api.param.consumer;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 客户管理分页入参
 *
 * @author zouweixiang
 * @date 2021/11/30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteConsumerListParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -7163013554197005319L;

    /**
     * 开发者端用户ID也就是unionid
     */
    private String partnerUserId;

    /**
     * 开放id
     */
    private String unionId;
    /**
     * 用户类型
     */
    private Integer userType;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 省
     */
    private String province;
    /**
     * 城市
     */
    private String city;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 注册开始时间
     */
    private Date registerStartTime;

    /**
     * 注册结束时间
     */
    private Date registerEndTime;

    /**
     * 订阅状态
     */
    private Integer subscribeStatus;

    /**
     * 是否返回数量
     */
    private Boolean isCount;

}
