package cn.com.duiba.user.server.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.tag.TagDto;
import cn.com.duiba.user.server.api.dto.tag.TagGroupDto;
import cn.com.duiba.user.server.api.param.tag.RemoteBatchTagUserParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagAddParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagDeleteParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagEditParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagGroupAddParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagGroupDeleteParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagGroupEditParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagGroupListParam;
import cn.com.duiba.user.server.api.param.tag.RemoteTagListParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 功能描述：标签管理
 *
 * @Auther: xiaotian
 * @Date: 2021/11/24 17:46
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 获取标签列表
     *
     * @param tagListParam 筛选参数
     * @return
     */
    PageResponse<TagDto> getTagList(RemoteTagListParam tagListParam);


    /**
     * 根据标签主键Id获取标签详情
     *
     * @param tagId
     * @return
     */
    TagDto getTag(Long tagId);

    /**
     * 根据标签组主键Id获取标签组详情
     *
     * @param tagGroupId
     * @return
     */
    TagGroupDto getTagGroup(Long tagGroupId);

    /**
     * 获取标签组列表
     *
     * @param tagGroupListParam 筛选参数
     * @return
     */
    PageResponse<TagGroupDto> getTagGroupList(RemoteTagGroupListParam tagGroupListParam);


    /**
     * 新增标签
     *
     * @param param 新增标签属性
     * @return
     */
    Long addTag(RemoteTagAddParam param) throws BizException;


    /**
     * 新增标签组
     *
     * @param param 新增标签组属性
     * @return
     */
    Long addTagGroup(RemoteTagGroupAddParam param) throws BizException;


    /**
     * 编辑标签
     *
     * @param param 编辑标签属性
     * @return
     */
    Boolean editTag(RemoteTagEditParam param) throws BizException;

    /**
     * 编辑标签组
     *
     * @param param 编辑标签属性
     * @return
     */
    Boolean editTagGroup(RemoteTagGroupEditParam param) throws BizException;

    /**
     * 删除标签
     *
     * @param id 标签id
     * @return
     */
    Boolean delTag(RemoteTagDeleteParam id) throws BizException;


    /**
     * 删除标签组
     *
     * @param id 标签组id
     * @return
     */
    Boolean delTagGroup(RemoteTagGroupDeleteParam id) throws BizException;


    /**
     * 用户打标签
     *
     * @param batchTagUserParam 打标签参数
     * @return
     */
    Boolean batchTagUser(RemoteBatchTagUserParam batchTagUserParam) throws BizException;


    /**
     * 用户移除标签
     *
     * @param batchTagUserParam 移除标签参数
     * @return
     */
    Boolean batchUnTagUser(RemoteBatchTagUserParam batchTagUserParam) throws BizException;

}
