/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.user.server.api.request;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerCookieDTO;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerDTO;
import cn.com.duiba.user.server.api.request.DuibaConsumerCookieClient;
import cn.com.duiba.user.server.api.request.KmsClient;
import cn.com.duiba.user.server.api.request.UserContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RequestLocal
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RequestLocal.class);
    private ApplicationContext applicationContext;
    private static DuibaConsumerCookieClient duibaConsumerCookieClient;

    public static void injectConsumerInfoIntoCookie(HttpServletResponse response, ConsumerDTO consumerDto) {
        ConsumerCookieDTO consumerCookieDto = duibaConsumerCookieClient.injectConsumerInfoIntoCookie(consumerDto, response);
        RequestLocal.setApiActivityContext(consumerCookieDto);
    }

    public static void setThreadLocally(HttpServletRequest request) throws BizException {
        ConsumerCookieDTO consumerFromWdata4 = duibaConsumerCookieClient.getConsumerCookieDto(request);
        RequestLocal.setApiActivityContext(consumerFromWdata4);
    }

    public static void setApiActivityContext(ConsumerCookieDTO consumerCookieDto) {
        if (null != consumerCookieDto) {
            UserContext.UserInfo userInfo = new UserContext.UserInfo();
            userInfo.setCid(consumerCookieDto.getCid());
            userInfo.setUid(consumerCookieDto.getPartnerUserId());
            userInfo.setUnionId(consumerCookieDto.getUnionId());
            userInfo.setLoginTime(consumerCookieDto.getTime());
            userInfo.setType(consumerCookieDto.getType());
            UserContext.setUserContext(userInfo);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        KmsClient kmsClient = (KmsClient)this.applicationContext.getBean(KmsClient.class);
        duibaConsumerCookieClient = new DuibaConsumerCookieClient(kmsClient);
    }
}

