package cn.com.duiba.user.server.api.dto.consumer;

import cn.com.duiba.user.server.api.dto.tag.TagDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 客户管理分页入参
 *
 * @author zouweixiang
 * @date 2021/11/30
 */
@Data
public class ConsumerListPageDTO implements Serializable {

    private static final long serialVersionUID = -7163013554197005319L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * 开放id
     */
    private String unionId;
    /**
     * 用户类型
     */
    private Integer userType;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 省
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 国家
     */
    private String country;

    /**
     * 订阅
     */
    private Integer subscribe;

    /**
     * 订阅时间
     */
    private Date subscribeTime;

    /**
     * 标记列表
     */
    private List<TagDto> tagList;

    /**
     * 标签id列表
     */
    private List<Long> tagIdList;
    /**
     * 标记str列表
     */
    private String tagStrList;
    /**
     * 创建时间-也是注册时间
     */
    private Date gmtCreate;
}
