/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.user.server.api.request;

import cn.com.duiba.user.server.api.dto.consumer.TimeBasedKeyDTO;
import cn.com.duiba.user.server.api.dto.consumer.TimeBasedRollingKeyDTO;
import cn.com.duiba.user.server.api.param.consumer.RemoteTimeBaseParam;
import cn.com.duiba.user.server.api.remoteservice.RemoteTimeBasedKeyService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class KmsClient {
    @Resource
    private RemoteTimeBasedKeyService remoteTimeBasedKeyService;
    private SecureRandom ranGen = new SecureRandom();
    private volatile List<TimeBasedRollingKeyDTO> cachedKeys;
    private volatile TimeBasedRollingKeyDTO currentCachedKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeBasedRollingKeyDTO getCachedTimeBasedRollingKey(long timestamp) {
        long now = System.currentTimeMillis();
        long oneDayAgo = now - 86400000L;
        if (timestamp > now + 300000L) {
            throw new IllegalArgumentException("timestamp must not after now");
        }
        if (timestamp < oneDayAgo) {
            throw new IllegalArgumentException("timestamp must not before oneDayAgo");
        }
        if (this.currentCachedKey == null || !this.currentCachedKey.isMatch(now)) {
            KmsClient kmsClient = this;
            synchronized (kmsClient) {
                if (this.currentCachedKey == null || !this.currentCachedKey.isMatch(now)) {
                    this.cachedKeys = this.getTimeBasedRollingKey();
                    for (TimeBasedRollingKeyDTO key : this.cachedKeys) {
                        if (!key.isMatch(now)) continue;
                        this.currentCachedKey = key;
                        break;
                    }
                }
            }
        }
        for (TimeBasedRollingKeyDTO key : this.cachedKeys) {
            if (!key.isMatch(timestamp)) continue;
            return key;
        }
        throw new IllegalStateException("timeBasedKey not found,timestamp is " + timestamp + ",currentCachedKeys:" + this.cachedKeys);
    }

    private List<TimeBasedRollingKeyDTO> getTimeBasedRollingKey() {
        long now = System.currentTimeMillis();
        Date oneDaysAgo = new DateTime(now).minusDays(1).minusMinutes(5).toDate();
        String day = DateUtils.getDayStr((Date)oneDaysAgo);
        Date tomorrow = new DateTime(now += 300000L).plusDays(1).toDate();
        List<TimeBasedKeyDTO> keys = this.remoteTimeBasedKeyService.findRecently(RemoteTimeBaseParam.builder().day(day).build()).getTimeBasedKeyList();
        Date createStartDay = null;
        if (keys.isEmpty()) {
            createStartDay = oneDaysAgo;
        } else {
            TimeBasedKeyDTO newestKey = keys.get(0);
            String newestDayInDb = newestKey.getValidDay();
            Date newestDateInDb = DateUtils.getDayDate((String)newestDayInDb);
            if (!newestDateInDb.after(new Date(now))) {
                createStartDay = DateUtils.daysAddOrSub((Date)newestDateInDb, (int)1);
            }
        }
        List<TimeBasedKeyDTO> createdKeys = this.createKeysFromDayUntilTomorrow(createStartDay, tomorrow);
        createdKeys.addAll(keys);
        ArrayList<TimeBasedRollingKeyDTO> dtos = new ArrayList<TimeBasedRollingKeyDTO>(createdKeys.size());
        for (TimeBasedKeyDTO e : createdKeys) {
            TimeBasedRollingKeyDTO dto = new TimeBasedRollingKeyDTO();
            dto.setSecretKey(e.getSecretKey());
            dto.setStartTimeMillis(DateUtils.getDayStartTime((String)e.getValidDay()).getTime());
            dto.setEndTimeMillis(DateUtils.daysAddOrSub((Date)new Date(dto.getStartTimeMillis()), (int)1).getTime());
            dtos.add(dto);
        }
        return dtos;
    }

    private List<TimeBasedKeyDTO> createKeysFromDayUntilTomorrow(Date createStartDay, Date tomorrow) {
        ArrayList<TimeBasedKeyDTO> list = new ArrayList<TimeBasedKeyDTO>(5);
        if (createStartDay == null) {
            return list;
        }
        Date date = createStartDay;
        Date dayAfterTomorrow = org.apache.commons.lang3.time.DateUtils.truncate((Date)DateUtils.daysAddOrSub((Date)tomorrow, (int)1), (int)5);
        while (date.before(dayAfterTomorrow)) {
            TimeBasedKeyDTO e = new TimeBasedKeyDTO();
            String day = DateUtils.getDayStr((Date)date);
            e.setValidDay(day);
            e.setSecretKey(this.createRandomKey());
            TimeBasedKeyDTO byCondition = this.remoteTimeBasedKeyService.findByCondition(RemoteTimeBaseParam.builder().day(day).build());
            if (byCondition == null || byCondition.getId() == null) {
                Integer successCount = this.remoteTimeBasedKeyService.addTimeBasedKey(e).getCount();
                if (successCount <= 0 && (e = this.remoteTimeBasedKeyService.findByCondition(RemoteTimeBaseParam.builder().day(day).build())) == null) {
                    throw new IllegalStateException();
                }
            } else {
                e = byCondition;
            }
            list.add(e);
            date = DateUtils.daysAddOrSub((Date)date, (int)1);
        }
        Collections.reverse(list);
        return list;
    }

    private String createRandomKey() {
        int len = 8;
        byte[] bs = new byte[len];
        this.ranGen.nextBytes(bs);
        return Hex.encodeHexString((byte[])bs);
    }
}

