package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.param.template.TemplatePushBatchParam;
import cn.com.duiba.wechat.server.api.param.template.TemplatePushParam;

/**
 * 模版消息远程接口
 *
 * @author zouweixiang
 * @date 2021/12/01
 */
@AdvancedFeignClient
public interface RemoteTemplatePushService {


    /**
     * 推送模版消息
     *
     * @param templatePushParam 模板参数推
     */
    void pushMsgTemplate(TemplatePushParam templatePushParam);


    /**
     * 批量推送模版消息
     *
     * @param templatePushBatchParam 模板参数推
     */
    void pushMsgBatchTemplate(TemplatePushBatchParam templatePushBatchParam);
}
