package cn.com.duiba.wechat.server.api.constant;

/**
 * 调用微信接口需要的字段
 *
 * @author zouweixiang
 * @date 2021/11/22
 */
public class WeChatParameterConstant {

    /**
     * 第三方平台appid
     */
    public static final String COMPONENT_APPID = "component_appid";

    /**
     * 第三方平台appsecret
     */
    public static final String COMPONENT_APPSECRET = "component_appsecret";

    /**
     * 第三方平台access_token
     */
    public static final String COMPONENT_ACCESS_TOKEN = "component_access_token";

    /**
     * 微信后台推送的ticket，此ticket会定时推送，具体请见本页的推送说明
     */
    public static final String COMPONENT_VERIFY_TICKET = "component_verify_ticket";

    /**
     * 授权方appid
     */
    public static final String AUTHORIZER_APPID = "authorizer_appid";

    /**
     * 接口调用凭据刷新令牌
     */
    public static final String AUTHORIZER_REFRESH_TOKEN = "authorizer_refresh_token";


    /**
     * 公众号的appid
     */
    public static final String APPID = "appid";

    /**
     * 密钥
     */
    public static final String SECRET = "SECRET";

    public static final String CODE = "code";

    public static final String GRANT_TYPE = "grant_type";

    /**
     * 公众号授权作用域，简单信息，静默授权
     */
    public static final String SNSAPI_BASE = "snsapi_base";

    /**
     * 公众号授权作用域，详情，需要用户授权
     */
    public static final String SNSAPI_USERINFO = "snsapi_userinfo";

    /**
     * 带参二维码
     */
    public static final String PARAM_EXPIRE_SECONDS = "expire_seconds";
    public static final String PARAM_ACTION_NAME = "action_name";
    public static final String PARAM_ACTION_INFO = "action_info";

    /**
     * 公众号授权码,会在授权成功时返回给第三方平台
     */
    public static final String AUTHORIZATION_CODE = "authorization_code";
    /**
     * openid
     */
    public static final String OPEN_ID = "openId";
    public static final String UNION_ID = "unionId";
}
