package cn.com.duiba.wechat.server.api.constant.enums;


import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author zouweixiang
 * @date 2021/11/26
 */
public enum WxPushMsgTypeEnum {
    /**
     * 推送消息类型
     */
    TEXT("text", "文本消息"),
    IMAGE("image", "图片消息"),
    VOICE("voice", "语音消息"),
    VIDEO("video", "视频消息"),
    SHORTVIDEO("shortvideo", "小视频消息"),
    LOCATION("location", "地理位置消息"),
    LINK("link", "链接消息"),
    EVENT("event", "事件"),

    /**
     * 事件类型
     */
    EVENT_SUBSCRIBE("subscribe", "关注事件"),
    EVENT_UNSUBSCRIBE("unsubscribe", "取关事件"),
    EVENT_SCAN("SCAN", "扫描带参数二维码事件（已关注用户）"),
    EVENT_LOCATION("LOCATION", "上报地理位置事件"),
    EVENT_CLICK("CLICK", "自定义菜单事件"),
    EVENT_VIEW("VIEW", "点击菜单跳转链接时的事件推送"),;

    private String msgType;

    private String desc;

    WxPushMsgTypeEnum(String msgType, String desc) {
        this.msgType = msgType;
        this.desc = desc;
    }

    private static final Map<String, WxPushMsgTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxPushMsgTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getMsgType(), tmp);
        }
    }
    public static WxPushMsgTypeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }
    public String getMsgType() {
        return msgType;
    }

    public String getDesc() {
        return desc;
    }
}
