package cn.com.duiba.wechat.server.api.constant.enums;

import lombok.Getter;

/**
 * 授权状态枚举
 *
 * @author zouweixiang
 * @date 2021/11/23
 */
@Getter
public enum AuthorizationStatusEnum {

    /**
     * 状态码
     */
    AUTHORIZED(0, "authorized"),

    UNAUTHORIZED(1, "unauthorized");

    /**
     * 枚举值
     */
    private final int code;

    /**
     * 枚举描述
     */
    private final String desc;


    AuthorizationStatusEnum(final int code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

}
