package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.constant.MinaConstant;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import com.alibaba.fastjson.JSONObject;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

import java.net.InetSocketAddress;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    private ConnectionConfig connectionConfig;

    public ConnectionClient() {
    }

    public void client(String ip,String post){
        connectionConfig = new ConnectionConfig.Builder(Integer.valueOf(post)).setIp(ip).build();
        connect();
    }

    public void connect() {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                messageReceived(session,message);
            }
        });
        connector.getFilterChain().addLast("logger", new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            IoSession ioSession = future.getSession();
            ClientPushEvent clientPushEvent = new ClientPushEvent();
            clientPushEvent.setUseId(1l);
            ioSession.write(clientPushEvent);
        }
    }

    /**
     * 客户端接收服务端推送消息的具体实现
     * @param session
     * @param message
     */
    public abstract void messageReceived(IoSession session,Object message);
}
