package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import com.alibaba.fastjson.JSONObject;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

import java.net.InetSocketAddress;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    private ConnectionConfig connectionConfig;

    public ConnectionClient(String ip,Integer port) {
        this.connectionConfig = new ConnectionConfig.Builder(port).setIp(ip).build();
    }

    public IoSession connect() {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                consumersReceived(session,message);
            }
        });
        connector.getFilterChain().addLast("logger", new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        IoSession ioSession = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            ioSession = future.getSession();
        }
        return ioSession;
    }

    public abstract void consumersReceived(IoSession session, Object message);
}
