package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.constant.MinaConstant;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

import java.net.InetSocketAddress;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    private ConnectionConfig connectionConfig;

    public IoSession connect(String ip){
        this.connectionConfig = new ConnectionConfig.Builder(MinaConstant.port).setIp(ip).build();
        return connect();
    }

    private IoSession connect() {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                consumersReceived(session,message);
            }
        });
        connector.getFilterChain().addLast("logger", new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        IoSession ioSession = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            ioSession = future.getSession();
        }
        return ioSession;
    }

    /**
     * 改方法接收服务端推送信息,具体业务需自己实现
     * @param session
     * @param message
     */
    public abstract void consumersReceived(IoSession session, Object message);
}
