/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public abstract class ConnectionClient {
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private Long useId;

    public void connect(String ip, Long useId) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).build();
        this.connect(useId);
    }

    private void connect(Long useId) {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                ConnectionClient.this.consumersReceived(session, message);
            }
        });
        connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            ClientPushEvent clientPushEvent = new ClientPushEvent();
            clientPushEvent.setUseId(useId);
            this.ioSession.write(clientPushEvent);
        }
    }

    public abstract void consumersReceived(IoSession var1, Object var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    public Long getUseId() {
        return this.useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
}

