package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.constant.MinaConstant;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

import java.net.InetSocketAddress;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    //链接配置
    private ConnectionConfig connectionConfig;
    //链接会话
    private IoSession ioSession;
    //客户端链接
    private static NioSocketConnector connector;
    //改客户端标识
    private Long useId;

    public void connect(String ip,Long useId){//初始化
        this.connectionConfig = new ConnectionConfig.Builder(MinaConstant.port).setIp(ip).build();
        connect(useId);
    }

    private void connect(Long useId) {
        connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                consumersReceived(session,message);
            }
        });
        connector.getFilterChain().addLast("logger", new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            //第一次链接时自报家门,现在是伪实现,之后应该在推送中标注
            ClientPushEvent clientPushEvent = new ClientPushEvent();
            clientPushEvent.setUseId(useId);
            ioSession.write(clientPushEvent);
        }
    }


    public void close(){
        if (null == connector)
            return;
        connector.dispose();
    }

    /**
     * 改方法接收服务端推送信息,具体业务需自己实现
     * @param session
     * @param message
     */
    public abstract void consumersReceived(IoSession session, Object message);

    public ConnectionConfig getConnectionConfig() {
        return connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public IoSession getIoSession() {
        return ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public static NioSocketConnector getConnector() {
        return connector;
    }

    public static void setConnector(NioSocketConnector connector) {
        ConnectionClient.connector = connector;
    }
}
