package cn.com.wawa.proxy.api.event;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * Created by danke on 2017/11/16.
 */
@AdvancedFeignClient
public interface RemotePushEvent {

    /**
     * 更具用户id推送
     * @param useId
     * @param pushEvent
     */
    void pushEventByUseId(Long useId, PushEvent pushEvent);

    /**
     * 批量推送指定标示事件
     */
    void pushEventByUseIds(List<Long> useIds, PushEvent pushEvent);

    /**
     * 给指定用户推送指定事件
     */
    void pushEventByMap(Map<Long,PushEvent> pushEventMap);

    /**
     * 推送给该服务器下所有会话用户
     * @param pushEvent
     */
    void pushEventAll(PushEvent pushEvent);

    /**
     * 推送给指定群组下所有会话
     */
    void pushEventAllByGroupId(Long groupId, PushEvent pushEvent);

    /**
     * 推送给指定群组下的,指定用户信息
     */
    void pushEventGroupAndUse(Long groupId, Long useId, PushEvent pushEvent);
}
