/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import com.alibaba.fastjson.JSONObject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public abstract class ConnectionClient {
    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGER = "logger";
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private Long useId;

    public void connect(String ip, Long useId) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).build();
        this.connect(useId);
    }

    private void connect(Long useId) {
        this.connector = new NioSocketConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                ClientPushEvent meaaageSer = (ClientPushEvent)JSONObject.parseObject((String)JSONObject.toJSONString((Object)message), ClientPushEvent.class);
                ConnectionClient.this.consumersReceived(session, meaaageSer);
            }
        });
        this.connector.getFilterChain().addLast(LOGGER, (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast(OBJECT_FILTER, (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            this.useId = this.ioSession.getId();
        }
    }

    public void close() {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            this.ioSession.getCloseFuture().setClosed();
            this.ioSession.getCloseFuture().awaitUninterruptibly();
        }
        this.connector.dispose();
    }

    public abstract void consumersReceived(IoSession var1, ClientPushEvent var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    public Long getUseId() {
        return this.useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }
}

