package cn.com.wawa.proxy.api.protocol;

import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;

import java.io.Serializable;

/**
 * Created by danke on 2017/11/20.
 * 长连接协议定义,客户端与服务端交互的最基本单位
 */
public class KeepAliveProtocol implements Serializable{

    /**
     * 通信标示,用于需要回调处理的消息
     */
    private Long id;
    /**
     * 通信状态码,服务端定义,用于回调处理时,判断消息发送是否成功
     */
    private String status;
    /**
     * action动作,用于交互时需要进行业务处理的动作标示
     *
     */
    private String action;
    /**
     * 消息类型
     */
    private String type;
    /**
     * 推送目的地,通过注册会话时的sessionKey来确定推送给哪个客户端
     */
    private String sessionKey;
    /**
     * 推送的具体内容实现
     */
    private ClientPushEvent clientPushEvent;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public ClientPushEvent getClientPushEvent() {
        return clientPushEvent;
    }

    public void setClientPushEvent(ClientPushEvent clientPushEvent) {
        this.clientPushEvent = clientPushEvent;
    }
}
