/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.enums.ProtocolActionEnum;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocol;
import com.alibaba.fastjson.JSONObject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);
    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGERSTR = "logger";
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private String useId;

    public void connect(String ip, String useId) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).build();
        this.useId = useId;
        this.connect();
    }

    private void connect() {
        this.connector = new NioSocketConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                KeepAliveProtocol protocol = (KeepAliveProtocol)JSONObject.parseObject((String)JSONObject.toJSONString((Object)message), KeepAliveProtocol.class);
                ConnectionClient.this.consumersReceived(session, protocol);
            }

            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("\u670d\u52a1\u7aef\u6b63\u5e38\u5173\u95ed\u4e86\u94fe\u63a5");
                ConnectionClient.this.close();
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
            }
        });
        this.connector.getFilterChain().addLast(LOGGERSTR, (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast(OBJECT_FILTER, (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            KeepAliveProtocol protocol = new KeepAliveProtocol();
            protocol.setAction(ProtocolActionEnum.CREATE_SESSION.getCode());
            protocol.setSessionKey(this.useId);
            this.ioSession.write((Object)protocol);
        }
    }

    public void close() {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            this.ioSession.getCloseFuture().setClosed();
            this.ioSession.getCloseFuture().awaitUninterruptibly();
        }
        this.connector.dispose();
    }

    public abstract void consumersReceived(IoSession var1, KeepAliveProtocol var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    public String getUseId() {
        return this.useId;
    }

    public void setUseId(String useId) {
        this.useId = useId;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }
}

