package cn.com.wawa.proxy.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/21.
 * 协议类型
 */
public enum ProtocolEnum {

    NOTIFIED("NOTIFIED","通知类型"),
    REQUEST("REQUEST","请求类型");

    private String code;
    private String msg;

    public static ProtocolEnum getByCode(String code) {
        for (ProtocolEnum enumVal : ProtocolEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    ProtocolEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
