package cn.com.wawa.proxy.api.event.impl;

import cn.com.wawa.proxy.api.event.PushEvent;

import java.io.Serializable;

/**
 * Created by danke on 2017/11/14.
 * 推送给客户端的事件,包含客户端状态变更所需要的值
 * 推送事件参数由上游准备,下游只负责推送
 */
public class ClientPushEvent<T> implements Serializable, PushEvent {

    /**
     * 用户id
     */
    private String useId;
    /**
     * 娃娃机id
     */
    private Long wawaId;
    /**
     * 业务类型
     */
    private String bizType;
    /**
     * 业务值
     */
    private String bizVal;
    /**
     * 群组id
     */
    private Long groupId;

    /**
     * 上下文,具体碰过之后定义,总感觉上面信息不够
     */
    private T context;

    public String getUseId() {
        return useId;
    }

    public void setUseId(String useId) {
        this.useId = useId;
    }

    public Long getWawaId() {
        return wawaId;
    }

    public void setWawaId(Long wawaId) {
        this.wawaId = wawaId;
    }

    public String getBizVal() {
        return bizVal;
    }

    public void setBizVal(String bizVal) {
        this.bizVal = bizVal;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public T getContext() {
        return context;
    }

    public void setContext(T context) {
        this.context = context;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }
}
