package cn.com.wawa.proxy.api.util;

import cn.com.wawa.proxy.api.constant.Constants;

/**
 * Created by danke on 2017/11/21.
 * 用于生成key标示的工具
 */
public class KeyUtil {

    private KeyUtil() {
    }

    /**
     * 用于生成clientKey标识,客户端的会话key
     * @param clientId 为客户端本身属性id,
     * @return
     */
    public static String createClientKey(Long  clientId){
        StringBuilder sb = new StringBuilder();
        sb.append(clientId).append("_").append(System.currentTimeMillis());
        return sb.toString();
    }

    /**
     * redis的二级key,用于获取对应客户端存在redis中的的ClientKey
     */
    public static String createRedisKeyByTypeAndId(String clientType,Long clientId){
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.MainConstants.WAWA_SECOND_KEY_PRIFOX)
                .append(clientType).append("_").append(clientId);
        return sb.toString();
    }
}
