package cn.com.wawa.proxy.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/20.
 * 协议中通信的action枚举
 */
public enum ProtocolActionEnum {

    CREATE_SESSION("CREATE_SESSION","创建会话"),
    CLOSE_SESSION("CLOSE_SESSION","关闭会话"),
    CLIENT_PUSH_EVENT("PUSH_EVENT","客户端推送事件");


    private String code;
    private String msg;

    ProtocolActionEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ProtocolActionEnum getByCode(String code) {
        for (ProtocolActionEnum enumVal : ProtocolActionEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
