package cn.com.wawa.proxy.api.protocol;

import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;

import java.io.Serializable;
import java.util.List;

/**
 * Created by danke on 2017/11/20.
 * 长连接协议定义,客户端与服务端交互的最基本单位
 */
public final class KeepAliveProtocol implements Serializable{

    /**
     * 通信标示,用于需要回调处理的消息
     */
    private Long id;
    /**
     * 通信状态码,服务端定义,用于回调处理时,判断消息发送是否成功
     */
    private String status;
    /**
     * action动作,用于交互时需要进行业务处理的动作标示
     *  ProtocolActionEnum
     */
    private String action;
    /**
     * 消息类型
     */
    private String type;
    /**
     * 消息版本号
     */
    private long version;
    /**
     * 客户端id,改客户端标识,比如用户-useId,娃娃机-wawaId
     */
    private Long clientId;
    /**
     * 该消息来自哪里,客户端的sessionKey,初始化链接时,该值为会话在redis中的key
     * 客户端发送的消息都必须带上该值
     */
    private String clientKey;
    /**
     * 该消息需要推送给到的sessionKey
     * 通过该值找到指定的会话,将消息推送
     */
    private List<String> pushClientKeys;
    /**
     * 推送的具体内容实现
     */
    private ClientPushEvent clientPushEvent;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ClientPushEvent getClientPushEvent() {
        return clientPushEvent;
    }

    public void setClientPushEvent(ClientPushEvent clientPushEvent) {
        this.clientPushEvent = clientPushEvent;
    }

    public List<String> getPushClientKeys() {
        return pushClientKeys;
    }

    public void setPushClientKeys(List<String> pushClientKeys) {
        this.pushClientKeys = pushClientKeys;
    }

    public String getClientKey() {
        return clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public long getVersion() {
        return version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }
}
