package cn.com.wawa.proxy.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/21.
 */
public enum ClientTypeEnum {

    APP("APP","用户端,app端"),
    WAWA("WAWA","娃娃机控制端");

    private String code;
    private String msg;

    public static ClientTypeEnum getByCode(String code) {
        for (ClientTypeEnum enumVal : ClientTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    ClientTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
